package music;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;

public class Compilation extends Album {
	
	private int noOfPerformers;

	public Compilation(String title, int year, Performer performer, Song[] songs, ArrayList<String> credits,
			GregorianCalendar releaseDate, int noOfPerformers) {
		super(title, year, performer, songs, credits, releaseDate);
		this.noOfPerformers = noOfPerformers;
	}
	
	public Compilation() {
		super();
	}

    public void prettyPrint() {
    	SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
        System.out.println("Album: " + super.getTitle() + " (" + super.getYear() + ")");
        System.out.println("(compilation; " + noOfPerformers + " performers)");
        System.out.println("Release date: " + df.format(super.getReleaseDate().getTime()));
        System.out.println("Songs: ");
        for (int i = 0; i < super.getSongs().length; i++) {
            System.out.println('\t' + super.getSongs()[i].getTitle());
        }
        System.out.println("Credits: ");
        for (int i = 0; i < super.getCredits().size(); i++) {
            System.out.println('\t' + super.getCredits().get(i));
        }
//        super.prettyPrint();
    }
    
	public int getNoOfPerformers() {
		return noOfPerformers;
	}

	public void setNoOfPerformers(int noOfPerformers) {
		this.noOfPerformers = noOfPerformers;
	}

}
